﻿  package{
	  import flash.display.*;
	  import flash.events.*;
	  import flash.net.*;
	  import flash.text.*;
	  import flash.geom.ColorTransform;
	  import flash.geom.Rectangle;
	  import flash.geom.Point;
	  import flash.ui.ContextMenu;
	  import flash.ui.ContextMenuItem;
	  import flash.external.ExternalInterface;
	  
	  public class MainClass extends MovieClip{
		public var prod:Boolean = true;		//production flag, set to false to test, set to true to product
		
		//uncomment this string in order to test this product, and set server url
		//public static var urlActions:String = "http://localhost/activeden/gallery_standart/admin/main.php";
		public static var urlActions:String = "";	//comment this string when you use test.
		
		//------------------------- don't change those variables -----------------	
		public static var urlGalleryActions:String = "";
		public static var userType:String = "user";
		public static var hash:String = "";
		public static var numDemo:String = "";
		
		private var loader:URLLoader = new URLLoader();
		
		public var centerPoint:Point;		//for dialogs
		public var boundRect:Rectangle;
		public var isWebsiteLoaded:Boolean = false;
		
		public var mc_dialogMessage:Dialog = new Dialog();
		
		public var strDefaultView:String = "admin";
		
		public var strUsername:String = "";
		public var strPassword:String = "";
		
		public var flag_appStartedOnce:Boolean = false;
		
		//inline elements:
		// mc_website
		// txt_status
		// mc_statusLine
		
		 //constructor
		 public function MainClass(){
			 initMain();
		 }
		
		 //--------------------------------------------------------------
		 // send data to javascript
		 private function sendToJavascript(arg) {
			var result:Object = ExternalInterface.call("flashCall", arg);
			trace(result);
		 } 
		 
		 //--------------------------------------------------------------
		 // get data from javascript
		 private function getFromJs(str:String) {
			this.handleServerResponse(str);
		 }
		 
		//--------------------------------------------------------------
		// init main class - called from constructor
		public function initMain() {
			ExternalInterface.addCallback("sendToFlash", getFromJs);
			
			hideAllElements();
			
			initEvents();
			
			//init center point for dialog
			this.centerPoint = new Point(Math.floor((this.width)/2),Math.floor((this.height)/2));
			this.boundRect = new Rectangle(this.x,this.y,this.width,this.height);
			
			this.addChild(this.mc_dialogMessage);
			this.mc_dialogMessage.visible = false;
			clearStatusRight();
			
			var valid:Boolean = setInitParams();
			if(valid == false) return(false);
						
			setContextMenu();
						
			setStatus("Load initial settings...");
			serverRequest("getInitSettings",new URLVariables(),"main");
		}
		
		//--------------------------------------------------------
		// set context menu for website object
		public function setContextMenu(){
			var menu:ContextMenu = new ContextMenu();
			menu.hideBuiltInItems();
			this.contextMenu = menu;
		}
		
		
		//--------------------------------------------------------
		// init class events.
		public function initEvents(){
			this.loader.addEventListener(Event.COMPLETE, serverResponse);
			this.loader.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityErrorHandler);
			this.loader.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
		}
		
		//--------------------------------------------------------
		// get url server and url gallery of the cms
		public function setInitParams(){
			if(this.prod == false) return(true);
			
			var paramObj:Object = LoaderInfo(this.root.loaderInfo).parameters;
			if(paramObj.url_server == null){
				toStartupErrorState("Parameter 'url_server' (flashvars) not found.\n Please specify it in html file");
				return(false);
			}
			
			//get demo
			if (paramObj.num_demo != null)
				MainClass.numDemo = paramObj.num_demo;
			
			MainClass.urlActions = paramObj.url_server;
			return(true);
		}
		
		//--------------------------------------------------------
		// catch security loader error event. Prints error message
		private function securityErrorHandler(event:SecurityErrorEvent){
			showErrorMessage("security error - unable to load request");
		}
		
		//--------------------------------------------------------
		// catch io loader error
		private function ioErrorHandler(event:IOErrorEvent):void{
			if(this.isWebsiteLoaded == false){
				trace(event.toString());
				toStartupErrorState("Error open url: " + MainClass.urlActions);
			}
			else showErrorMessage("io error - unable to load request");
		}
		 		
		//--------------------------------------------------------
		// show error message
		public function showErrorMessage(message:String){
			trace(message);
			mc_dialogMessage.show("error","Error occured",message);
		}
		
		//--------------------------------------------------------
		//old server request
		private function oldServerRequest(strAction:String, vars:URLVariables, from:String) {
			var request:URLRequest = new URLRequest(MainClass.urlActions);
			
			vars.clientAction = strAction;
			vars.fromObject = from;
			vars.hash = MainClass.hash;
			if (MainClass.numDemo != "")
				vars.demo = MainClass.numDemo;
				
			request.method = URLRequestMethod.POST;
			request.data = vars;
			
			try{
                this.loader.load(request);
            } catch(error:Error){
				//showErrorMessage("Unable to load request");
				if(strAction == "getInitSettings"){
					var strError:String = "url: " + MainClass.urlActions + " not found as server url. \n Please specify it in swf parameters";
					toStartupErrorState(strError);
				}
				else setStatusError("Unable to load request, try one more time!!!");
            }
		}
		
		//--------------------------------------------------------
		// takes an initial settings from php
		public function serverRequest(strAction:String, vars:URLVariables, from:String) {
			
			if (this.prod == false) {
				this.oldServerRequest(strAction,vars,from);
				return(false);
			}
			
			//prepare data for sending
			vars.clientAction = strAction;
			vars.fromObject = from;
			vars.hash = MainClass.hash;
			this.sendToJavascript(vars);
		}
		
		//--------------------------------------------------------
		// hide all elements
		public function hideAllElements(){
			 mc_website.visible = false;
			 mc_statusLine.visible = false;
			 txt_status.visible = false;
		}
		
		//--------------------------------------------------------
		// switch to startup error state, hide all other elements.
		public function toStartupErrorState(strError:String){
			 hideAllElements();
			 this.mc_dialogMessage.show("error","Error - can't load application",strError);
		}
		
		//--------------------------------------------------------
		// check if this is startup error - go to startup state if do.
		function checkStartupError(){
			if(this.isWebsiteLoaded == true) return(false);
			var txt:String = "Wrong server url: " + MainClass.urlActions;
			toStartupErrorState(txt)
		}
		
		//--------------------------------------------------------
		// handle response from the server
		private function handleServerResponse(strXml:String) {
			clearStatus();
			try {
				var xmlData:XML=new XML(strXml);
			} catch(error){
				trace(strXml);
				setStatusError("Error occurred!!!");
				checkStartupError();
				return(false);
			}
						
			xmlData.ignoreWhitespace=true;
						
			//validate xml for data and success properties
			if(xmlData.action == undefined){
				trace(strXml);
				setStatusError("Error occurred!!!");
				checkStartupError();
				return(false);
			}
			
			if(xmlData.success == undefined){
				trace("success property not found!");
				trace(xmlData);
				setStatusError("Error occurred with server xml output!!!");
				checkStartupError();
				return(false);
			}
			
			// check if success false - show error message and return false.
			var success:Boolean = Boolean(xmlData.success.toString());
			if(success == false){
				//check unauthorized:
				if(xmlData.authorized != undefined){
					if(xmlData.authorized.toString() == "false"){
						return(false);
					}
				}
				   
				showErrorMessage("Response error: " + xmlData.message.toString());
				return(false)
			}
						
			switch(xmlData.fromobject.toString()){
				case "main":
					switch(xmlData.action.toString()){
						case "getInitSettings":
							setInitSettings(xmlData);
						break;
						default:
							trace("flash, main, action not found: " + xmlData.action);
						break;
					}
				break;
				case "website":
				default:
					this.mc_website.serverResponse(xmlData);
				break;
			}
		}
		
		//--------------------------------------------------------
		// gets the response from the server
		private function serverResponse(event:Event){
			var strXml:String = this.loader.data;
			this.handleServerResponse(strXml);
		}
		
		 //----------------------------------------------------------------
		 // start application website.
		 public function startApp(){
			this.mc_website.visible = true;
			this.mc_statusLine.visible = true;
			
			doUserTypePreveleges();
			
			//init site only once.
			if(this.flag_appStartedOnce == false) 
				this.mc_website.initSite(MainClass.urlActions);						
			this.flag_appStartedOnce = true;
			
			this.mc_website.restart();
		 }
		 
		 
		 //----------------------------------------------------------------
		 // run when the user logged in
		 public function userLoggedIn(userType:String,hash:String){
			 if(userType == "admin") MainClass.userType = "admin";
			 else MainClass.userType = "user";
			 MainClass.hash = hash;
			 startApp();			 
		 }
		 
		 //----------------------------------------------------------------
		 //do some preveleges according user type
		 public function doUserTypePreveleges(){
		 }
		 				
		//--------------------------------------------------------
		//set some color to status line
		public function formatStatusLine(colorNumber:Number,bold:Boolean){			
			var col:ColorTransform = this.txt_status.transform.colorTransform;			
			col.color = colorNumber;
			this.txt_status.transform.colorTransform  =  col;
			
			var format:TextFormat = new TextFormat();
			format.bold = bold;
			this.txt_status.setTextFormat(format);			
		}
		
		//--------------------------------------------------------
		//set status line in error style
		public function setStatusError(text:String){
			if(this.txt_status == null) return(false);
			setStatus(text);
			formatStatusLine(0xEA3E3E,true);
			
		}
		
		//--------------------------------------------------------
		//sets status line
		public function setStatus(text:String){
			if(this.txt_status == null) return(false);
			this.txt_status.visible = true;
			this.txt_status.text = text;
			
			//change color to white
			formatStatusLine(0xFFFFFF,false);
		}
				
		//--------------------------------------------------------
		//clear status line
		public function clearStatus(){
			if(this.txt_status == null) return(false);
			this.txt_status.text = "";			
			this.txt_status.visible = false;
		}
		
		//--------------------------------------------------------
		// set right status line
		public function setStatusRight(str:String){
			this.txt_statusRight.visible = true;
			this.txt_statusRight.text = str;
		}		
		
		//-----------------------------------------------------------------------
		// clear right status line
		public function clearStatusRight(){
			this.txt_statusRight.text = "";
			this.txt_statusRight.visible = false;
		}
				
		//-------------------------------------------------------------------
		//sets init settings from response xml
		public function setInitSettings(xml:XML){
			var arrSettings = xml.arrSettings;
			
			MainClass.urlGalleryActions = arrSettings.urlGallery.toString();
			
			//set default user type:
			MainClass.userType = "user";
			if(arrSettings.defaultView.toString() == "admin") MainClass.userType = "admin";
			
			this.isWebsiteLoaded = true;	//for startup error
			
			startApp();
		}
		
		
	  }
  }